require( "locations/machines.lua" );

flameObject = {
    baseDir = "assets/anim/iquitos/",    
    assets = {
	    background = {
	        { state="default",  file="background_01", base = 2},
	        { state="upgrade1", file="background_02", base = 2},
	        { state="upgrade2", file="background_03", base = 2},
        },
    },
    children = {
        flame = {
            continuous = true,
            visible = true,
            x = 0, y = 0,
            assets = {
                flame = {
                    { state="default",  file="background_01", base = 4, play = "DoFlame"},
	                { state="upgrade1", file="background_02", base = 4, play = "DoFlame"},
	                { state="upgrade2", file="background_03", base = 4, play = "DoFlame"},
                },
            },
        },
    },
}

iquitosBackground = {
	
	baseDir = "assets/anim/iquitos/",
	mouse = false,
	---------------------------------------------------------- Background image with upgrades
	
	name = "background_object",
	spriteLayer = -2,
	
	assets = {
		background = {
			{ state="default",  file="background_01", base = 0},
			{ state="upgrade1", file="background_02", base = 0},
			{ state="upgrade2", file="background_03", base = 0},
		},
	},
	
	statics = {
	    spriteLayer = -1,
	    visible = false,
	    
	    ------------------------------------------ kStatic1 mask
	    static_1 = {
	        name = "background_static_1",
	        upgrade = "kStatic1",
		    assets = {
			    background = {
			        { state="default",  file="background_01", base = 1},
			        { state="upgrade1", file="background_02", base = 1},
			        { state="upgrade2", file="background_03", base = 1},
		        },
		    },
	    },
	    ------------------------------------------ kStatic2 parrot
	    static_2 = {
	        spriteLayer = 10,
	        name = "background_static_2",
	        upgrade = "kStatic2",
	        continuous = true,
		    assets = {
			    background = {
			        { state="default",  file="background_01", base = 7, play="DoParrot" },
			        { state="upgrade1", file="background_02", base = 7, play="DoParrot" },
			        { state="upgrade2", file="background_03", base = 7, play="DoParrot" },
		        },
		    },
	    },
	    ------------------------------------------ kStatic3 torches
	    static_3 = {
	        name = "background_static_3",
	        upgrade = "kStatic3",
	        style = flameObject,
        },
        static_3_1 = {
	        name = "background_static_3_1",
	        upgrade = "kStatic3",
	        style = flameObject,
	        x = 200 + (122 - (0.85 * 122)), y = -35 + (137 - (137 * 0.85)),
	        scale = {0.85, 0.85},
        },
        static_3_2 = {
	        name = "background_static_3_2",
	        upgrade = "kStatic3",
	        style = flameObject,
	        x = 345 + (122 - (0.65 * 122)), y = -62 + (137 - (137 * 0.65)),
	        scale = {0.65, 0.65},
        },
        ------------------------------------------ kStatic4 rugs
	    static_4 = {
	        name = "background_static_4",
	        upgrade = "kStatic4",
		    assets = {
			    background = {
			        { state="default",  file="background_01", base = 3},
			        { state="upgrade1", file="background_02", base = 3},
			        { state="upgrade2", file="background_03", base = 3},
		        },
		    },
	    },
	    ------------------------------------------ kSteam1 steam booster
	    static_booster = machine_booster,
	    ------------------------------------------ kPhonograph1 phonograph
	    static_phono = machine_phono,
    },
    anims = {
	    ------------------------------------------ kAnim1 upgrade object
	    anim_1 = {
	    },
	    ------------------------------------------ kAnim2 upgrade object
	    anim_2 = {
	    },
	},
}